function [RRS_index , numberOfRRS , fullDigest_forward_iTRF , fullDigest_reverse_iTRF] = InSilicoDigestion(RRS , sequence)
%
% using imput:
% sequence = speciesSequence (16S rRNA sequence to be digested)
% RRS= probe_sequence (restriction recognition site)
% 
% output:
% RRS_index (list of RRS)
% numberOfRRS (amount of RRS)
% fullDigest_forward_iTRF (forward in silico terminal restriction fragment (iTRF))
% fullDigest_reverse_iTRF (reverse in silico terminal restriction fragment (iTRF))



%% match RRS string
% find RRS in sequence string
RRS_index = regexpi(sequence,RRS);

if(isempty(RRS_index))
    % no RRS --> no digestion
    
    fullDigest_forward_iTRF = length(sequence);
    fullDigest_reverse_iTRF = length(sequence);
    
    numberOfRRS = 0;
   
    % close/end the function
    return
end

% since regexpi() gives back the first position of match ('Agct') the RRS
% is at the match position + 1 nt
RRS_index = RRS_index + 1;

% determine number of RRS in sequence
numberOfRRS = length(RRS_index);


%% forward fragments of full digest
 
% after the full/complete digest of the DNA by the restriction enzyme the
% smalles forward labled TRF has the length of the sequence from the beginning of the
% primer to the RRS
fullDigest_forward_iTRF = RRS_index(1);


%% reverse fragments of full digest

% after the full/complete digest of the DNA by the restriction enzyme the
% smalles reverse labled TRF has the length of the sequence minus the last RRS
fullDigest_reverse_iTRF = length(sequence) - RRS_index(length(RRS_index));



end